/*
 * I_fc_usb_tcu_JSONParser.h
 *
 *  Created on: Mar 19, 2015
 *      Author: kl81hc
 */

#ifndef I_FC_USB_TCU_JSONPARSER_H_
#define I_FC_USB_TCU_JSONPARSER_H_

#include "fc_usb_tcu_AppMain.h"
//#define   _NEW
//#include "json.h"
//#undef   _NEW
#include "usb_tcu_api_types.h"
#include "json_utils.h"

class I_fc_usb_tcu_JSONParser:public fc_usb_tcu_tclBaseIf
{
public:
	I_fc_usb_tcu_JSONParser(fc_usb_tcu_tclAppMain* poMainAppl):fc_usb_tcu_tclBaseIf(poMainAppl) {;};
   virtual ~I_fc_usb_tcu_JSONParser();
   virtual const tChar* getIfName() const { return "I_fc_usb_tcu_JSONParser"; };

	virtual tBool vParseChannelDataJSON(Json::Value& root, T_tcu_channel_data_result& oChannelData) = 0;
	virtual tBool vParseChannelMasterDataJSON(Json::Value& root, T_tcu_channel_master_data_result& oChannelMasterData) = 0;
	virtual tBool vParseChargingStationsData(tU32& u32ClientToken,Json::Value& root, T_tcu_response_charging_stations_list_result& oChargingStationsData) = 0;
	virtual tBool vParseChargingSpotData(Json::Value & ChargingSpotData, T_tcu_charging_spot& oChargingSpotData) = 0;

	/* @rav1hc: EV Feature only for JPN */
	virtual tBool vParseChargingSpotDataforJPN(tU32& u32ClientToken,Json::Value & ChargingSpotDataJPN, T_tcu_charging_spot_data_JPN& oChargingSpotDataJPN) = 0;
	virtual tBool vParseVacancySpotDataforJPN(tU32& u32ClientToken,Json::Value & VacancySpotDataJPN, T_tcu_vacancy_spot_data_JPN& oVacancySpotDataJPN) = 0;

	//-----------------------------------------------------------------------------------------------------------------------------------------
	virtual tBool vParseVacantStationsData(tU32& u32ClientToken,Json::Value& root, T_tcu_response_vacancy_stations_list_result& oVacantStationsData) = 0;
	virtual tBool vParseVICSData(Json::Value & VICSData, T_tcu_VICS_Response_Data& oVICSData) = 0;
	virtual tBool bParsePartAuthResponseJSON(Json::Value & response, T_tcu_PartAuthentication_Response_Data& tPartAuth) = 0;
	virtual tBool bParseUserAuthResponseJSON(Json::Value & response, T_tcu_UserAuthToken_Response_Data& tUserAuth) = 0;
	virtual tBool bParseDecodedIdToken(Json::Value & root_in, std::string& root_out) = 0;
	virtual tBool bGetTokenArray(Json::Value & root_in, Json::Value& root_out) = 0;
	virtual tBool bParseFavoriteChannelList(Json::Value& root, T_tcu_Favorite_Channel_List& oFavoriteChannelDataList)
	{
		(void)root;
		(void)oFavoriteChannelDataList;
		return false;
	};
	virtual tBool bParseAuthenticationResultData(Json::Value jAuthenticationResultData, T_tcu_AuthenticationResultData& oAuthenticationResultData)
	{
		(void)jAuthenticationResultData;
		(void)oAuthenticationResultData;
		return false;		
	};

	tBool bParseGeneralResponse(Json::Value& root, T_tcu_GeneralResponse& oGeneralResponseMessage);
	tBool bParseGeneralNotificationMessage(Json::Value& root, T_tcu_GeneralNotificationMessage& oGeneralNotificationMessage);
	tBool bParseIconDataMessage(Json::Value& root, T_tcu_IconList& oIconList);
	tBool bParseConnectedSearchJSON(Json::Value& root, T_tcu_connected_search_result& oConnectedSearch);
	tBool bParseDataRecord(Json::Value root, T_tcu_Data_Record& oDataRecord);
	tBool bParseLocation(Json::Value& root, T_tcu_Location& oLocation);
	tBool bParseServerListJSON(Json::Value& root, T_tcu_Server_Info_List& oServerInfoList);
	tBool bParseDataConnectionError(Json::Value& root, tU16& u16DataConnectionError, tU16& u16ErrorRequestType);
	tBool bParseDTCConnectionStatus(Json::Value& root, tBool bDTCConnectionStatus);
	tBool bParseDataConnectionStatus(Json::Value& root, T_e8_tcu_DataConnectionStatus& oDataConnectionStatus);
	tInt tIntGetFID(Json::Value & root);
	tU32 tU32GetID(Json::Value & root);
	tBool bGetItems(Json::Value & root,Json::Value &jItemList);
	tBool bParseCarwingsDate(Json::Value & root, T_tcu_carwings_date& oCarwingsDate);
protected:
	 json_utils jsonUtils;
};


#endif /* I_FC_USB_TCU_JSONPARSER_H_ */
